//------------------------------------------------------------
// VelociBus_4X4BP Initialization & Diagnostic Example
// Each module will show it's address (index+1) by the number of illuminated LEDs
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
VelociBus_4X4BP vbus; // create VelociBus interface, one required for each serial port used
#define VBUS_SERIAL    Serial2
#define SERIAL_MONITOR Serial

void setup() 
{
#ifdef SERIAL_MONITOR  
  // Serial monitor
  SERIAL_MONITOR.begin(115200); // set your serial monitor speed to match
  SERIAL_MONITOR.println("VelociBus_4X4BP Initialization & Diagnostic Example");
#endif

  // button module on VelociBus
  VBUS_SERIAL.begin(38400); // VelociBus is always 38400
}

void loop() 
{
  // report the number of button pad modules in chain
  if (!vbus.begin( &VBUS_SERIAL,10 )) // performs loopback diagnostic, tries 10 times, sets board_count
  {
#ifdef SERIAL_MONITOR  
    Serial.println("Loopback Negative - No boards found!");
#endif
    return;
  }

#ifdef SERIAL_MONITOR  
  Serial.print("Found boards: "); Serial.println(vbus.board_count);
#endif

  // identify modules
  for (uint b=0; b < vbus.board_count; b++)
  { VelociBus_4X4BP::color_code c = (b < 15) ? (VelociBus_4X4BP::color_code)(b+1) : VelociBus_4X4BP::red;
    for (uint n=0; n < 16; n++)
      vbus.setLED( b, n, VelociBus_4X4BP::FCN_COLOR, (n <= b) ? c : VelociBus_4X4BP::black );
  }

  // listen for buttons
  for (uint32_t tm=millis(); millis()-tm < 1000UL; )
  { VelociBus_4X4BP::button_info btn;
    if (vbus.getButton( &btn ))
    {
#ifdef SERIAL_MONITOR
      SERIAL_MONITOR.print("Button "); SERIAL_MONITOR.print(btn.button_index); SERIAL_MONITOR.print(" board "); Serial.println(btn.board_address);
#endif
      vbus.setLED( btn.board_address, btn.button_index, VelociBus_4X4BP::FCN_COLOR, (VelociBus_4X4BP::color_code)random(1,16) );
      tm=millis();
    }
  } 
}
